<style>
	#external-links .card{
		padding-left: 10px;
		padding-right: 10px;
		padding-top: 5px;
		padding-bottom: 10px;
	}
	#external-links a{
		text-decoration: underline;
	}
	#external-links li:first-child{
		padding-right: 10px;
	}
	#external-links li:last-child{
		padding-left: 10px;
	}
</style>

<div id="external-links" class="cisstat-publisher-blog">
	<ul class="display-style-icon list-unstyled row ">
		<#if entries?has_content>
			<#list entries as entry>
				<#assign
					entry = entry
					entryId = entry.getEntryId()
					assetRenderer = entry.getAssetRenderer()
					entryTitle = htmlUtil.escape(assetRenderer.getTitle(locale))
				/>
				<#assign docXml = saxReaderUtil.read(entry.getAssetRenderer().getArticle().getContent()) />
				<#assign href = docXml.valueOf("//dynamic-element[@name='readmore']/dynamic-content/text()") />
				<li class="lfr-asset-item" style="width:50%;">
					<div class="taglib-vertical-card entry-display-style ">
						<div class="card">
							<div class="editIcon">
								<span><@getEditIcon /></span>
							</div>
							<div class="date"></div>
							<a href="${href}" target="_blank">
								<div class="cis-text-color">${entryTitle}</div>
							</a>
						</div>
					</div>
				</li>
			</#list>
		</#if>
	</ul>
</div>
<#macro getMetadataField fieldName>
	<span class="metadata-entry">
		<#assign dateFormat = "dd.MM.yyyy" />
		<#if fieldName == "create-date">
			${dateUtil.getDate(entry.getCreateDate(), dateFormat, locale)}
		</#if>
	</span>
</#macro>
<#macro getEditIcon>
	<#if assetRenderer.hasEditPermission(themeDisplay.getPermissionChecker())>
		<#assign redirectURL = renderResponse.createRenderURL() />
		${redirectURL.setParameter("mvcPath", "/add_asset_redirect.jsp")}
		${redirectURL.setWindowState("pop_up")}
		<#assign editPortletURL = assetRenderer.getURLEdit(renderRequest, renderResponse, windowStateFactory.getWindowState("pop_up"), redirectURL)!"" />
		<#if validator.isNotNull(editPortletURL)>
			<#assign title = languageUtil.format(locale, "edit-x", entryTitle, false) />
			<@liferay_ui["icon"]
				iconCssClass="icon-edit-sign"
				message=title
				url="javascript:Liferay.Util.openWindow({id:'" + renderResponse.getNamespace() + "editAsset', title: '" + title + "', uri:'" + htmlUtil.escapeURL(editPortletURL.toString()) + "'});"
			/>
		</#if>
	</#if>
</#macro>